<?php
defined('_JEXEC') or die;
require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'functions.php';

// Create alias for $this object reference.
$document = & $this;

// Shortcut for template base url.
$templateUrl = $document->baseurl . '/templates/' . $document->template;

// Initialize version-specific view.
$version = new JVersion();
$view = $this->artx = ('1.5' == $version->RELEASE) ? new ArtxPage15($this) : new ArtxPage16($this);

// Decorate component with Artisteer style.
$view->componentWrapper();
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php echo $document->language; ?>" lang="<?php echo $document->language; ?>" >
<head>
 <jdoc:include type="head" />
 <link rel="stylesheet" href="<?php echo $document->baseurl; ?>/templates/system/css/system.css" type="text/css" />
 <link rel="stylesheet" href="<?php echo $document->baseurl; ?>/templates/system/css/general.css" type="text/css" />
 <link rel="stylesheet" type="text/css" href="<?php echo $templateUrl; ?>/css/template.css" media="screen" />
 <!--[if IE 6]><link rel="stylesheet" href="<?php echo $templateUrl; ?>/css/template.ie6.css" type="text/css" media="screen" /><![endif]-->
 <!--[if IE 7]><link rel="stylesheet" href="<?php echo $templateUrl; ?>/css/template.ie7.css" type="text/css" media="screen" /><![endif]-->
 <script type="text/javascript">if ('undefined' != typeof jQuery) document._artxJQueryBackup = jQuery;</script>
 <script type="text/javascript" src="<?php echo $templateUrl; ?>/jquery.js"></script>
 <script type="text/javascript">jQuery.noConflict();</script>
 <script type="text/javascript" src="<?php echo $templateUrl; ?>/script.js"></script>
 <script type="text/javascript">if (document._artxJQueryBackup) jQuery = document._artxJQueryBackup;</script>
</head>
<body class="<?php echo $view->bodyClass(); ?>">
<div id="chfa-main">
    <div class="cleared reset-box"></div>
<div class="chfa-sheet">
    <div class="chfa-sheet-tl"></div>
    <div class="chfa-sheet-tr"></div>
    <div class="chfa-sheet-bl"></div>
    <div class="chfa-sheet-br"></div>
    <div class="chfa-sheet-tc"></div>
    <div class="chfa-sheet-bc"></div>
    <div class="chfa-sheet-cl"></div>
    <div class="chfa-sheet-cr"></div>
    <div class="chfa-sheet-cc"></div>
    <div class="chfa-sheet-body">
<div class="chfa-header">
    <div class="chfa-header-clip">
    <div class="chfa-header-center">
        <div class="chfa-header-jpeg"><a href="/index.php"><img src="images/spacer.gif" width="1000" height="100"></a></div>
    </div>
    </div>
<div class="chfa-logo"><a href="/index.php"><img src="images/spacer.gif" width="1000" height="100"></a></div>

</div>
<div class="cleared reset-box"></div>
<?php if ($view->containsModules('user3', 'extra1', 'extra2')) : ?>
<div class="chfa-nav">
	<div class="chfa-nav-l"></div>
	<div class="chfa-nav-r"></div>
<div class="chfa-nav-outer">
	<?php if ($view->containsModules('extra1')) : ?>
	<div class="chfa-hmenu-extra1"><?php echo $view->position('extra1'); ?></div>
	<?php endif; ?>
	<?php if ($view->containsModules('extra2')) : ?>
	<div class="chfa-hmenu-extra2"><?php echo $view->position('extra2'); ?></div>
	<?php endif; ?>
	<?php echo $view->position('user3'); ?>
</div>
</div>
<div class="cleared reset-box"></div>
<?php endif; ?>
<?php echo $view->position('banner1', 'chfa-nostyle'); ?>
<?php echo $view->positions(array('top1' => 33, 'top2' => 33, 'top3' => 34), 'chfa-block'); ?>
<div class="chfa-content-layout">
    <div class="chfa-content-layout-row">
<?php if ($view->containsModules('left')) : ?>
<div class="chfa-layout-cell chfa-sidebar1">
<?php echo $view->position('left', 'chfa-block'); ?>

  <div class="cleared"></div>
</div>
<?php endif; ?>
<div class="chfa-layout-cell chfa-content">

<?php
  echo $view->position('banner2', 'chfa-nostyle');
  if ($view->containsModules('breadcrumb'))
    echo artxPost($view->position('breadcrumb'));
  echo $view->positions(array('user1' => 50, 'user2' => 50), 'chfa-article');
  echo $view->position('banner3', 'chfa-nostyle');
  if ($view->hasMessages())
    echo artxPost('<jdoc:include type="message" />');
  echo '<jdoc:include type="component" />';
  echo $view->position('banner4', 'chfa-nostyle');
  echo $view->positions(array('user4' => 50, 'user5' => 50), 'chfa-article');
  echo $view->position('banner5', 'chfa-nostyle');
?>

  <div class="cleared"></div>
</div>
<?php if ($view->containsModules('right')) : ?>
<div class="chfa-layout-cell chfa-sidebar2">
<?php echo $view->position('right', 'chfa-block'); ?>

  <div class="cleared"></div>
</div>
<?php endif; ?>

    </div>
</div>
<div class="cleared"></div>


<?php echo $view->positions(array('bottom1' => 33, 'bottom2' => 33, 'bottom3' => 34), 'chfa-block'); ?>
<?php echo $view->position('banner6', 'chfa-nostyle'); ?>
<div class="chfa-footer">
    <div class="chfa-footer-t"></div>
    <div class="chfa-footer-l"></div>
    <div class="chfa-footer-b"></div>
    <div class="chfa-footer-r"></div>
    <div class="chfa-footer-body">
        <?php echo $view->position('syndicate'); ?>
                <div class="chfa-footer-text">
                    <?php if ($view->containsModules('copyright')): ?>
                    <?php echo $view->position('copyright', 'chfa-nostyle'); ?>
                    <?php else: ?>
                    <?php ob_start(); ?>
<p>&nbsp;</p>

<p>&copy; <?php echo date("Y"); ?> Crosshairs LLC<br />
502.298.8870<br />
DUN: 068783360<br /></p>


                    <?php echo str_replace('%YEAR%', date('Y'), ob_get_clean()); ?>
                    <?php endif; ?>
                </div>
        <div class="cleared"></div>
    </div>
</div>

		<div class="cleared"></div>
    </div>
</div>
<div class="cleared"></div>
<p class="chfa-page-footer"><a href="http://www.drudgemm.com" target="_blank"><img src="http://www.drudgemm.com/images/drudgeLinkIcon2.gif"></a></p>

    <div class="cleared"></div>
</div>

<?php echo $view->position('debug'); ?>
</body>
</html>